# -*- coding: utf-8 -*-
"""
Created on Tue Apr 27 13:26:25 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'Selected files'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

selected_files = ['dyrvik_IGLED19-Batch 23_0040B0_5_0.tiv_processed', \
                 'dyrvik_IGLED19-Batch 23_0040AE_8_0.tiv_processed']
# highest EQE of each type. Both look quite representative in degradation rate.

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  
    
"""Prepare plots"""
label_strings = ['11 nm TFB, no ALD',\
                 '3.3 nm TFB, 10 c. ALD']

fig = plt.figure(0)
fig.set_size_inches(9,8)
fig.set_tight_layout(True)
ax = plt.gca()
ax.set_xlabel('Time [s]')
ax.set_ylabel('EQE [%]')

"""Plot the data"""
file_path = os.path.join(data_folder_path,selected_files[0])
df = pd.read_csv(file_path)
ax.plot(df['Time[s]'], df['EQE [%]']/df['EQE [%]'][0], color=COLOURS_GREENS[900], label=label_strings[0])
    
file_path = os.path.join(data_folder_path,selected_files[1])
df = pd.read_csv(file_path)
ax.plot(df['Time[s]'], df['EQE [%]']/df['EQE [%]'][0], color=COLOURS_ORANGES[300], label=label_strings[1])
    
"""Axis settings"""
ax.set_ylabel('$\mathregular{EQE_{EL}}$ (normalized)')
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(0.2))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.1))

"""Legend"""
leg = ax.legend(frameon=False)

# Right-aligning the legend
vp = leg._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Annotation"""
ax.text(0.05, 0.05, 'J = 10 $\mathregular{mA/cm^2}$',
        horizontalalignment='left',
        verticalalignment='bottom',
        transform=ax.transAxes)

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' Stability curves normalized'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
export_name_png = plot_name + '.png'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
png_path = os.path.join(export_folder_path,export_name_png)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
fig.savefig(png_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)

